# Script pour corriger l'encodage des fichiers PowerShell
# Convertit tous les fichiers .ps1 en UTF-8 avec BOM pour compatibilite
# Traite uniquement les fichiers modifies dans la derniere heure

$scriptPath = Split-Path -Parent $MyInvocation.MyCommand.Path
$oneHourAgo = (Get-Date).AddHours(-1)

# Filtrer les fichiers .ps1 modifies dans la derniere heure
$psFiles = Get-ChildItem -Path $scriptPath -Filter "*.ps1" | 
    Where-Object { 
        $_.Name -ne "Fix-Encoding.ps1" -and 
        $_.LastWriteTime -gt $oneHourAgo 
    }

Write-Host "Fichiers modifies dans la derniere heure: $($psFiles.Count)" -ForegroundColor Cyan
Write-Host "Correction de l'encodage..." -ForegroundColor Yellow

foreach ($file in $psFiles) {
    try {
        # Lire le contenu actuel
        $content = Get-Content -Path $file.FullName -Raw -Encoding UTF8
        
        # Reecrire en UTF-8 avec BOM
        $utf8WithBom = New-Object System.Text.UTF8Encoding $true
        [System.IO.File]::WriteAllText($file.FullName, $content, $utf8WithBom)
        
        Write-Host "OK $($file.Name) - Encodage corrige" -ForegroundColor Green
    }
    catch {
        Write-Host "ERREUR $($file.Name) - Erreur: $($_.Exception.Message)" -ForegroundColor Red
    }
}

Write-Host ""
Write-Host "Correction terminee. Les fichiers sont maintenant en UTF-8 avec BOM." -ForegroundColor Green
Write-Host "Cela devrait resoudre les problemes d'accents sur differents PC." -ForegroundColor Cyan
